/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.bookmark;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.datasource.Service;
import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.datasource.rmi.DBService;
import de.willuhn.jameica.bookmark.Context;
import de.willuhn.jameica.messaging.QueryMessage;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.Plugin;
import de.willuhn.jameica.plugin.ServiceDescriptor;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class ContextSerializer {
    public Context serialize(Object context) {
        if (context == null) {
            return null;
        }
        Context result = new Context();
        Plugin plugin = Application.getPluginLoader().findByClass(context.getClass());
        if (plugin != null) {
            result.setPlugin(plugin.getManifest().getName());
            QueryMessage msg = new QueryMessage(context);
            Application.getMessagingFactory().getMessagingQueue("jameica.bookmark." + result.getPlugin() + ".serialize").sendSyncMessage(msg);
            Object response = msg.getData();
            if (response instanceof String && context != response) {
                result.setSerialized((String)response);
                return result;
            }
        }
        result.setClassName(context.getClass().getName());
        if (context instanceof DBObject) {
            try {
                result.setId(((DBObject)context).getID());
            }
            catch (RemoteException e) {
                Logger.error((String)"unable to determine object ID", (Throwable)e);
            }
        }
        return result;
    }

    public Object unserialize(Context context) {
        if (context == null) {
            return null;
        }
        try {
            ServiceDescriptor[] serviceNames;
            BeanService bs = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            String plugin = StringUtils.trimToNull((String)context.getPlugin());
            String className = StringUtils.trimToNull((String)context.getClassName());
            String id = StringUtils.trimToNull((String)context.getId());
            String serialized = context.getSerialized();
            if (plugin == null) {
                if (className == null) {
                    return null;
                }
                Class c = Application.getClassLoader().load(className);
                return bs.get(c);
            }
            Manifest mf = Application.getPluginLoader().getManifestByName(plugin);
            if (mf == null) {
                return null;
            }
            if (!StringUtils.isEmpty((String)serialized)) {
                QueryMessage msg = new QueryMessage(serialized);
                Application.getMessagingFactory().getMessagingQueue("jameica.bookmark." + plugin + ".unserialize").sendSyncMessage(msg);
                Object response = msg.getData();
                if (response != null && response != serialized) {
                    return response;
                }
                return null;
            }
            if (className == null) {
                return null;
            }
            Class c = mf.getClassLoader().load(className);
            if (!DBObject.class.isAssignableFrom(c)) {
                return bs.get(c);
            }
            Class pluginClass = mf.getClassLoader().load(mf.getPluginClass());
            for (ServiceDescriptor s : serviceNames = mf.getServices()) {
                Service service = Application.getServiceFactory().lookup(pluginClass, s.getName());
                if (!(service instanceof DBService)) continue;
                return ((DBService)service).createObject(c, id);
            }
        }
        catch (Exception e) {
            Logger.write((Level)Level.DEBUG, (String)"unable to unserialize context", (Throwable)e);
        }
        return null;
    }
}

